package com.xd.layoutkotlinstartercode

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import android.widget.Toast

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
    }

    fun onLinearLayoutClicked(v: View) {
        if (v.id == R.id.btn_linear_layout) { //XD added
            val intent = Intent(this, LinearLayoutActivity::class.java)
            startActivity(intent)
            Toast.makeText(this, "onLinearoutClicked", Toast.LENGTH_SHORT).show();
        }
    }

    fun onRelativeLayoutClicked(v: View?) {
        val intent = Intent(this, RelativeLayoutActivity::class.java)
        startActivity(intent)
    }

    fun onScrollViewLayoutClicked(v: View?) {
        val intent = Intent(this, ScrollViewLayoutActivity::class.java)
        startActivity(intent)
    }

    fun onDateTimeLayoutClicked(v: View?) {
        val intent = Intent(this, DateAndTimeActivity::class.java)
        startActivity(intent)
    }

    fun onSharedPreferencesClicked(v: View?) {
        val intent = Intent(this, SharedPreferencesActivity::class.java)
        startActivity(intent)
    }

    fun onConstraintLayoutClicked(v: View?) {
        val intent = Intent(this, ConstraintLayoutActivity::class.java)
        startActivity(intent)
    }

    fun onListViewLayoutClicked(v: View?) {
        val intent = Intent(this, ListViewLayoutActivity::class.java)
        startActivity(intent)
    }
}