package com.xd.lifecyclekotlin

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity

class ActivityA : AppCompatActivity() {
    private var mActivityName: String? = null
    private var mStatusView: TextView? = null
    private var mStatusAllView: TextView? = null
    private val mStatusTracker = StatusTracker.getInstance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_a)

        mActivityName = getString(R.string.activity_a)
        mStatusView = findViewById<View>(R.id.status_view_a) as TextView
        mStatusAllView = findViewById<View>(R.id.status_view_all_a) as TextView
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_create))
        Utils.printStatus(mStatusView, mStatusAllView)
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        Log.d("XD", "onSaveInstanceState() called")
    }

    override fun onStart() {
        super.onStart()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_start))
        Utils.printStatus(mStatusView, mStatusAllView)
    }

    override fun onRestart() {
        super.onRestart()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_restart))
        Utils.printStatus(mStatusView, mStatusAllView)
    }

    override fun onResume() {
        super.onResume()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_resume))
        Utils.printStatus(mStatusView, mStatusAllView)
    }

    override fun onPause() {
        super.onPause()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_pause))
        Utils.printStatus(mStatusView, mStatusAllView)
    }

    override fun onStop() {
        super.onStop()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_stop))
    }

    override fun onDestroy() {
        super.onDestroy()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_destroy))
        mStatusTracker.clear()
    }

    fun startDialog(v: View?) {
        val intent = Intent(this@ActivityA, DialogActivity::class.java)
        startActivity(intent)
    }

    fun startActivityB(v: View?) {
        val intent = Intent(this@ActivityA, ActivityB::class.java)
        startActivity(intent)
    }

    fun startActivityC(v: View?) {
        val intent = Intent(this@ActivityA, ActivityC::class.java)
        startActivity(intent)
    }

    fun finishActivityA(v: View?) {
        finish()
    }

}