package com.xd.lifecyclekotlin

import android.content.Intent
import android.os.Bundle
import android.view.View
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity

class ActivityB : AppCompatActivity() {
    private var mActivityName: String? = null
    private var mStatusView: TextView? = null
    private var mStatusAllView: TextView? = null
    private val mStatusTracker = StatusTracker.getInstance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_b)

        mActivityName = getString(R.string.activity_b_label)
        mStatusView = findViewById<View>(R.id.status_view_b) as TextView
        mStatusAllView = findViewById<View>(R.id.status_view_all_b) as TextView
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_create))
        Utils.printStatus(mStatusView, mStatusAllView)
    }


    override fun onStart() {
        super.onStart()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_start))
        Utils.printStatus(mStatusView, mStatusAllView)
    }

    override fun onRestart() {
        super.onRestart()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_restart))
        Utils.printStatus(mStatusView, mStatusAllView)
    }

    override fun onResume() {
        super.onResume()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_resume))
        Utils.printStatus(mStatusView, mStatusAllView)
    }

    override fun onPause() {
        super.onPause()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_pause))
        Utils.printStatus(mStatusView, mStatusAllView)
    }

    override fun onStop() {
        super.onStop()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_stop))
    }

    override fun onDestroy() {
        super.onDestroy()
        mStatusTracker.setStatus(mActivityName, getString(R.string.on_destroy))
    }

    fun startDialog(v: View?) {
        val intent = Intent(this@ActivityB, DialogActivity::class.java)
        startActivity(intent)
    }

    fun startActivityA(v: View?) {
        val intent = Intent(this@ActivityB, ActivityA::class.java)
        startActivity(intent)
    }

    fun startActivityC(v: View?) {
        val intent = Intent(this@ActivityB, ActivityC::class.java)
        startActivity(intent)
    }

    fun finishActivityB(v: View?) {
        finish()
    }
}