package com.xd.listviewofprofscoroutinekotlin

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.ArrayAdapter
import android.widget.ListView
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import java.util.ArrayList

class MainActivity : AppCompatActivity() {
    private lateinit var arrayList: ArrayList<String>
    private lateinit var arrayAdapter: ArrayAdapter<String>
    private lateinit var myListView: ListView
    private lateinit var myViewModel: MyViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        myListView = findViewById(R.id.myListView)
        arrayList = ArrayList()
        arrayAdapter = ArrayAdapter(this, android.R.layout.simple_list_item_1, arrayList)
        myListView.adapter = arrayAdapter
        myViewModel = ViewModelProvider(this).get(MyViewModel::class.java)
        myViewModel.nameToShow.observe(this, Observer { it ->
            arrayAdapter.clear();
            arrayAdapter.addAll(it)
            arrayAdapter.notifyDataSetChanged()
        })
    }
}