package com.xd.myrundatacollectorkotlin

import android.Manifest
import android.app.Activity
import android.app.NotificationManager
import android.content.Intent
import android.content.pm.PackageManager
import android.os.Build
import android.os.Bundle
import android.os.Environment
import android.view.View
import android.widget.Button
import android.widget.RadioButton
import android.widget.RadioGroup
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import java.io.File

class MainActivity : AppCompatActivity() {
    private enum class State {
        IDLE, COLLECTING, TRAINING, CLASSIFYING
    }

    private val mLabels = arrayOf<String>(Globals.CLASS_LABEL_STANDING,
            Globals.CLASS_LABEL_WALKING, Globals.CLASS_LABEL_RUNNING,
            Globals.CLASS_LABEL_OTHER)

    private lateinit var radioGroup: RadioGroup
    private val radioBtns = arrayOfNulls<RadioButton>(4)
    private lateinit var mServiceIntent: Intent
    private lateinit var mFeatureFile: File
    private lateinit var mState: State
    private lateinit var btnDelete: Button

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        setContentView(R.layout.activity_main)
        checkPermissions(this)
        radioGroup = findViewById(R.id.radioGroupLabels) as RadioGroup
        radioBtns[0] = findViewById(R.id.radioStanding) as RadioButton
        radioBtns[1] = findViewById(R.id.radioWalking) as RadioButton
        radioBtns[2] = findViewById(R.id.radioRunning) as RadioButton
        radioBtns[3] = findViewById(R.id.radioOther) as RadioButton

        btnDelete = findViewById(R.id.btnDeleteData) as Button

        mState = State.IDLE
        mFeatureFile = File(getExternalFilesDir(null), Globals.FEATURE_FILE_NAME)
        mServiceIntent = Intent(this, SensorService::class.java)
    }

    fun onCollectClicked(view: View) {
        if (mState == State.IDLE) {
            mState = State.COLLECTING
            (view as Button).setText(R.string.ui_collector_button_stop_title)
            btnDelete.isEnabled = false
            radioBtns[0]!!.isEnabled = false
            radioBtns[1]!!.isEnabled = false
            radioBtns[2]!!.isEnabled = false
            radioBtns[3]!!.isEnabled = false
            val acvitivtyId = radioGroup.indexOfChild(findViewById(radioGroup.checkedRadioButtonId))
            val label = mLabels[acvitivtyId]
            val extras = Bundle()
            extras.putString(Globals.CLASS_LABEL_KEY, label)
            mServiceIntent.putExtras(extras)
            startService(mServiceIntent)
        } else if (mState == State.COLLECTING) {
            mState = State.IDLE
            (view as Button).setText(R.string.ui_collector_button_start_title)
            btnDelete.isEnabled = true
            radioBtns[0]!!.isEnabled = true
            radioBtns[1]!!.isEnabled = true
            radioBtns[2]!!.isEnabled = true
            radioBtns[3]!!.isEnabled = true
            stopService(mServiceIntent)
            (getSystemService(NOTIFICATION_SERVICE) as NotificationManager).cancelAll()
        }
    }

    fun onDeleteDataClicked(view: View?) {

        if (Environment.MEDIA_MOUNTED == Environment.getExternalStorageState()) {
            if (mFeatureFile.exists()) {
                mFeatureFile.delete()
            }
            Toast.makeText(applicationContext,
                    R.string.ui_collector_toast_file_deleted,
                    Toast.LENGTH_SHORT).show()
        }
    }

    override fun onBackPressed() {
        if (mState == State.TRAINING) {
            return
        } else if (mState == State.COLLECTING || mState == State.CLASSIFYING) {
            stopService(mServiceIntent)
            (getSystemService(NOTIFICATION_SERVICE) as NotificationManager).cancel(Globals.NOTIFICATION_ID)
        }
        super.onBackPressed()
    }

    override fun onDestroy() {
        // Stop the service and the notification.
        // Need to check whether the mSensorService is null or not.
        if (mState == State.TRAINING) {
            return
        } else if (mState == State.COLLECTING || mState == State.CLASSIFYING) {
            stopService(mServiceIntent)
            (getSystemService(NOTIFICATION_SERVICE) as NotificationManager).cancelAll()
        }
        finish()
        super.onDestroy()
    }

    fun checkPermissions(activity: Activity) {
        if (Build.VERSION.SDK_INT < 23) return
        if (ContextCompat.checkSelfPermission(activity, Manifest.permission.WRITE_EXTERNAL_STORAGE) !== PackageManager.PERMISSION_GRANTED) {
            ActivityCompat.requestPermissions(activity, arrayOf(Manifest.permission.WRITE_EXTERNAL_STORAGE), 0)
        }
    }
}