package com.xd.postdelayedkotlin

import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import java.util.*

class MainActivity : AppCompatActivity() {
    private lateinit var showTimeRunnable: Runnable
    private lateinit var calendar: Calendar
    private lateinit var textView: TextView
    private lateinit var handler: Handler

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        handler = Handler(Looper.getMainLooper())
        textView = findViewById(R.id.text_label)

        showTimeRunnable = Runnable {
            calendar = Calendar.getInstance()
            textView.text = "${calendar.get(Calendar.HOUR)} : ${calendar.get(Calendar.MINUTE)} : ${calendar.get(Calendar.SECOND)}"
            handler.postDelayed(showTimeRunnable, 1000)
        }
        handler.post(showTimeRunnable)
//        show_time_runnable.run()
    }

    override fun onPause() {
        super.onPause()
        handler.removeCallbacks(showTimeRunnable)
    }
}