package com.xd.roomdatabasekotlin

import androidx.annotation.WorkerThread
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers.IO
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.launch

//A Repository manages queries and allows you to use multiple backends.
// In the most common example, the Repository implements the logic for
// deciding whether to fetch data from a network or use results cached in a local database.
class CommentRepository(private val commentDatabaseDao: CommentDatabaseDao) {

    val allComments: Flow<List<Comment>> = commentDatabaseDao.getAllComments()

    fun insert(comment: Comment){
        CoroutineScope(IO).launch{
            commentDatabaseDao.insertComment(comment)
        }
    }

    fun delete(id: Long){
        CoroutineScope(IO).launch {
            commentDatabaseDao.deleteComment(id)
        }
    }

    fun deleteAll(){
        CoroutineScope(IO).launch {
            commentDatabaseDao.deleteAll()
        }
    }
}