package com.xd.roomdatabasekotlin

import android.app.Activity
import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.BaseAdapter
import android.widget.TextView

class MyListAdapter(private val context: Context, private var commentList: List<Comment>) : BaseAdapter(){

    override fun getItem(position: Int): Any {
        return commentList.get(position)
    }

    override fun getItemId(position: Int): Long {
        return position.toLong()
    }

    override fun getCount(): Int {
        return commentList.size
    }

    override fun getView(position: Int, convertView: View?, parent: ViewGroup?): View {
        val view: View = View.inflate(context, R.layout.layout_adapter,null)

        val textViewID = view.findViewById(R.id.tv_number) as TextView
        val textViewComment = view.findViewById(R.id.tv_string) as TextView

        textViewID.text = commentList.get(position).id.toString()
        textViewComment.text = commentList.get(position).comment

        return view
    }

    fun replace(newCommentList: List<Comment>){
        commentList = newCommentList
    }

}