package com.xd.threadviewmodelkotlin

import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ArrayAdapter
import android.widget.ListView
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import java.util.*

class MyFragment : Fragment() {
    private lateinit var arrayList: ArrayList<String>
    private lateinit var arrayAdapter: ArrayAdapter<String>
    private lateinit var myListView: ListView
    private lateinit var myViewModel: MyViewModel

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val view = inflater.inflate(R.layout.fragment_my, container, false)
        myListView = view.findViewById(R.id.myListView)
        arrayList = ArrayList()

        arrayAdapter = ArrayAdapter(requireActivity(), android.R.layout.simple_list_item_1, arrayList)
        myListView.adapter = arrayAdapter

        myViewModel = ViewModelProvider(requireActivity()).get(MyViewModel::class.java)
        myViewModel.nameToShow.observe(requireActivity(), Observer { it ->
            arrayAdapter.clear();
            arrayAdapter.addAll(it)
            arrayAdapter.notifyDataSetChanged()
        })
        return view
    }


}